
<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Info Widget .
 *
 */
class Tourm_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'tourmcontactinfo';
	}
	public function get_title() {
		return __( 'Contact Info', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() { 

		$this->start_controls_section(
			'title_section',
			[
				'label' 	=> __( 'Contact Info', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two'] );

		tourm_general_fields( $this, 'title', 'Title', 'TEXT', 'Projects', [ '2' ] );


		$repeater2 = new Repeater();

		tourm_media_fields( $repeater2, 'icon', 'Icon Image' );
		tourm_general_fields( $repeater2, 'label', 'Label', 'TEXT', 'Address' );
		tourm_general_fields( $repeater2, 'info', 'Informations', 'WYSIWYG', 'Address' );

		

		$this->add_control(
			'slides2',
			[
				'label' 		=> __( 'Slides', 'tourm' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'client_image'	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ label }}}',
				'condition'		=> [ 
					'layout_style' => [ '1','2'],
				],
				
			]
		);
		
		
		


        $this->end_controls_section();

        //---------------------------------------

		//-------Description Style-------
		tourm_common_style_fields( $this, 'label', 'Info Title', '{{WRAPPER}} .title', ['1'] );
		tourm_common_style_fields( $this, 'desc3', 'Info', '{{WRAPPER}} .info',['1'],'--light-color' );

		
	}

	protected function render() {

        $settings = $this->get_settings_for_display(); 

			
		if( $settings['layout_style'] == '1' ){

			echo '<div class="row gy-4 justify-content-center">';
				foreach( $settings['slides2'] as $data ){
	                echo '<div class="col-xl-4 col-lg-6">';
	                    echo '<div class="about-contact-grid style2">';
	                        echo '<div class="about-contact-icon">';
	                            if(!empty($data['icon']['url'])){
				                	echo tourm_img_tag( array(
										'url'	=> esc_url( $data['icon']['url'] ),
									) );
				                } 
	                        echo '</div>';
	                        echo '<div class="about-contact-details">';
	                        	if($data['label']){
		                            echo '<h6 class="box-title title">'.esc_html($data['label']).'</h6>';
		                        }
		                        if($data['info']){
		                        	
				                	echo wp_kses_post( $data['info'] );
				                	
				                } 
	                            
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}else{
			echo '<div class="widget footer-widget">';
				if( !empty( $settings['title'] ) ){
	                echo '<h3 class="widget_title title">'.esc_html( $settings['title'] ).'</h3>';
	            }
                echo '<div class="th-widget-contact">';
                	foreach( $settings['slides2'] as $data ){
	                    echo '<div class="info-box_text">';
	                    	if(!empty($data['icon']['url'])){
		                        echo '<div class="icon"><img src="'.esc_url( $data['icon']['url'] ).'" alt="img"></div>';
		                    }
	                        echo '<div class="details">';
	                           	if($data['info']){
				                	echo wp_kses_post( $data['info'] );
				                } 
	                            
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';
		}
	}
}
