<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Testimonial Slider Widget .
 *
 */
class tourm_Testimonial extends Widget_Base{

	public function get_name() {
		return 'tourmtestimonialslider';
	}
	public function get_title() {
		return __( 'Testimonials', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Testimonial Slider', 'tourm' ), 
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two', 'Style Three', 'Style Four', 'Style Five', 'Style Six' ] );

		tourm_media_fields( $this, 'image', 'Bg Image', [ '1','3' ] );
		tourm_media_fields( $this, 'quote', 'Quote Image', [ '2','5' ] );
		tourm_media_fields( $this, 'shape', 'Shape Image', [ '5' ] );

		tourm_general_fields( $this, 'title', 'Title', 'TEXT', 'Take a look at our modern apartment' , [ '3' ] );
		tourm_general_fields( $this, 'subtitle', 'SubTitle', 'TEXT', 'Take a look' , [ '3' ] );


		$repeater = new Repeater();

		tourm_media_fields( $repeater, 'client_image', 'Client Image' );
		tourm_general_fields( $repeater, 'client_name', 'Client Name', 'TEXT', 'Alex Michel' );
		tourm_general_fields( $repeater, 'client_desig', 'Client Designation', 'TEXT', 'Ui/Ux Designer' );
		tourm_general_fields( $repeater, 'client_feedback', 'Client Feedback', 'TEXTAREA', 'Our knowledgeable technicians are happy to provide tips' );

		tourm_select_field( $repeater, 'client_rating', 'Client Rating', [ 'One Star', 'Two Star', 'Three Star', 'Four Star', 'Five Star' ] );

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'tourm' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_image'	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
				'condition'		=> [ 
					'layout_style' => [ '1','2','3','4','5','6'],
				],
			]
		);

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
		//-------Name Style-------
		tourm_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .title', ['4'] );
		tourm_common_style_fields( $this, 'name', 'Name', '{{WRAPPER}} .name' );
		//-------Designation Style-------
		tourm_common_style_fields( $this, 'designation', 'Designation', '{{WRAPPER}} .desig' );
		//-------Feedback Style-------
		tourm_common_style_fields( $this, 'feedback', 'Feedback', '{{WRAPPER}} .text' );
		
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="row justify-content-center">';
                echo '<div class="col-xl-12">';

                	$bg = $settings['image']['url'] ? $settings['image']['url'] : '#';

                    echo '<div class="testi-review" data-bg-src="'.esc_url( $bg ).'">';

                    	$i = 0;
                        foreach( $settings['slides'] as $data ){
                        	$i++;

                        	$active_class = $i == 1 ? 'item-active' : '';

	                        echo '<div class="testi-box hover-item  '.esc_attr( $active_class ).'">';
	                            echo '<div class="testi-box_content feature-card-active-wrap">';
	                            	if(!empty($data['client_feedback'])){
		                                echo '<p class="testi-box_text text">'.esc_html( $data['client_feedback'] ).'</p>';
		                            }
	                                echo '<div class="testi-box_review">';
	                                    if( $data['client_rating'] == '1' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '2' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '3' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '4' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}else{
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
										}
	                                echo '</div>';
	                            echo '</div>';
	                            echo '<div class="testi-box_profile">';
	                            	if(!empty($data['client_image']['url'])){
		                                echo '<div class="testi-box_avater">';
		                                    echo '<span></span>';
		                                    echo tourm_img_tag( array(
												'url'	=> esc_url( $data['client_image']['url'] ),
											) );
		                                echo '</div>';
		                            }
	                                echo '<div class="media-body">';
	                                	if(!empty($data['client_name'])){
											echo '<h3 class="box-title name">'.esc_html( $data['client_name'] ).'</h3>';
										}
										if(!empty($data['client_desig'])){
											echo '<span class="testi-box_desig desig">'.esc_html( $data['client_desig'] ).'</span>';
										}
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="container-fluid p-0">';
				echo '<div class="slider-area">';
	                echo '<div class="swiper th-slider testiSlider1 has-shadow" id="testiSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"767":{"slidesPerView":"2","centeredSlides":"true"},"992":{"slidesPerView":"2","centeredSlides":"true"},"1200":{"slidesPerView":"2","centeredSlides":"true"},"1400":{"slidesPerView":"3","centeredSlides":"true"}}}\'>';
	                    echo '<div class="swiper-wrapper">';

	                        foreach( $settings['slides'] as $data ){
		                        echo '<div class="swiper-slide">';
		                            echo '<div class="testi-card">';
		                                echo '<div class="testi-card_wrapper">';
		                                    echo '<div class="testi-card_profile">';
		                                    	if(!empty($data['client_image']['url'])){
			                                        echo '<div class="testi-card_avater">';
			                                            echo tourm_img_tag( array(
															'url'	=> esc_url( $data['client_image']['url'] ),
														) );
			                                        echo '</div>';
			                                    }
		                                        echo '<div class="media-body">';
		                                        	if(!empty($data['client_name'])){
														echo '<h3 class="box-title name">'.esc_html( $data['client_name'] ).'</h3>';
													}
													if(!empty($data['client_desig'])){
														echo '<span class="testi-box_desig desig">'.esc_html( $data['client_desig'] ).'</span>';
													}
		                                        echo '</div>';
		                                    echo '</div>';
		                                    echo '<div class="testi-card_review">';
		                                        if( $data['client_rating'] == '1' ){
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
												}elseif( $data['client_rating'] == '2' ){
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
												}elseif( $data['client_rating'] == '3' ){
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
												}elseif( $data['client_rating'] == '4' ){
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
												}else{
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
												}
		                                    echo '</div>';
		                                echo '</div>';
		                                if(!empty($data['client_feedback'])){
			                                echo '<p class="testi-card_text text">'.esc_html( $data['client_feedback'] ).'</p>';
			                            }
			                            if(!empty( $settings['quote']['url'] )){
			                                echo '<div class="testi-card-quote">';
			                                    echo tourm_img_tag( array(
													'url'	=> esc_url( $settings['quote']['url'] ),
												) );
			                                echo '</div>';
			                            }
		                            echo '</div>';
		                        echo '</div>';
		                    }
	                    echo '</div>';
	                    echo '<div class="slider-pagination"></div>';
	                echo '</div>';
	            echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){

			$bg = $settings['image']['url'] ? $settings['image']['url'] : '#';
			echo '<div class="testi-area3 bg-bottom-center overflow-hidden space" data-bg-src="'.esc_url( $bg ).'">';
				echo '<div class="container">';
					echo '<div class="title-area text-center">';
						if(!empty( $settings['title'] )){
			                echo '<span class="sub-title">'.esc_html( $settings['title'] ).'</span>';
			            }
			            if(!empty( $settings['subtitle'] )){
			                echo '<h2 class="sec-title">'.esc_html( $settings['subtitle'] ).'</h2>';
			            }
		            echo '</div>';
		            echo '<div class="row justify-content-center">';
		                echo '<div class="col-xl-12">';
		                    echo '<div class="swiper th-slider testiSlide3" id="testiSlide3" data-slider-options=\'{"effect":"slide","loop":false,"thumbs":{"swiper":".testi-grid-thumb"}}\'>';
		                        echo '<div class="swiper-wrapper">';

		                        	foreach( $settings['slides'] as $data ){
			                            echo '<div class="swiper-slide">';
			                                echo '<div class="testi-grid">';
			                                	if(!empty($data['client_image']['url'])){
			                                        echo '<div class="testi-grid_author">';
			                                            echo tourm_img_tag( array(
															'url'	=> esc_url( $data['client_image']['url'] ),
														) );
			                                        echo '</div>';
			                                    }
			                                    echo '<div class="testi-grid_content">';
			                                    	if(!empty($data['client_feedback'])){
						                                echo '<p class="testi-grid_text text">'.esc_html( $data['client_feedback'] ).'</p>';
						                            }
						                            if(!empty($data['client_name'])){
														echo '<h6 class="testi-grid_name box-title name">'.esc_html( $data['client_name'] ).'</h6>';
													}
													if(!empty($data['client_desig'])){
														echo '<span class="testi-grid_desig desig">'.esc_html( $data['client_desig'] ).'</span>';
													}
			                                    echo '</div>';
			                                echo '</div>';
			                            echo '</div>';
			                        }
		                        echo '</div>';
		                        echo '<div class="slider-pagination"></div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="swiper th-slider testi-grid-thumb" data-slider-options=\'{"effect":"slide","slidesPerView":"6","spaceBetween":7,"loop":false}\'>';
		            echo '<div class="swiper-wrapper">';

		                foreach( $settings['slides'] as $data ){
		                	if(!empty($data['client_image']['url'])){
				                echo '<div class="swiper-slide">';
				                    echo '<div class="box-img">';
				                        echo tourm_img_tag( array(
											'url'	=> esc_url( $data['client_image']['url'] ),
										) );
				                    echo '</div>';
				                echo '</div>';
				            }
			            }
		            echo '</div>';
		        echo '</div>';
	        echo '</div>';
		}elseif( $settings['layout_style'] == '4' ){
			echo '<div class="swiper th-slider testiSlide5" id="testiSlide5" data-slider-options=\'{"effect":"slide","loop":false,"thumbs":{"swiper":".testi-grid2-thumb"}}\'>';
                echo '<div class="swiper-wrapper">';

                	foreach( $settings['slides'] as $data ){
	                    echo '<div class="swiper-slide">';
	                        echo '<div class="testi-grid2">';
	                            echo '<div class="box-content">';
	                            	if(!empty($data['client_feedback'])){
		                                echo '<p class="box-text text">'.esc_html( $data['client_feedback'] ).'</p>';
		                            }
		                            if(!empty($data['client_name'])){
										echo '<h6 class="box-title name">'.esc_html( $data['client_name'] ).'</h6>';
									}
									if(!empty($data['client_desig'])){
										echo '<span class="box-desig desig">'.esc_html( $data['client_desig'] ).'</span>';
									}
	                                echo '<div class="box-review">';
	                                    if( $data['client_rating'] == '1' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '2' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '3' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '4' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}else{
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
										}
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';
            echo '<div class="swiper th-slider testi-grid2-thumb" data-slider-options=\'{"effect":"slide","slidesPerView":"6","spaceBetween":7,"loop":false}\'>';
                echo '<div class="swiper-wrapper">';

                    foreach( $settings['slides'] as $data ){
	                    echo '<div class="swiper-slide">';
	                        echo '<div class="box-img">';
	                            echo tourm_img_tag( array(
									'url'	=> esc_url( $data['client_image']['url'] ),
								) );
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
                echo '<div class="icon-box">';
                    echo '<button data-slider-prev="#testiSlide5" class="slider-arrow default"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/right-arrow2.svg" alt=""></button>';
                    echo '<button data-slider-next="#testiSlide5" class="slider-arrow default"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow2.svg" alt=""></button>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="container-fluid p-0">';
				echo '<div class="slider-area">';
	                echo '<div class="swiper th-slider testiSlider6 has-shadow" id="testiSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"767":{"slidesPerView":"2","centeredSlides":"true"},"992":{"slidesPerView":"2","centeredSlides":"true"},"1200":{"slidesPerView":"2","centeredSlides":"true"},"1400":{"slidesPerView":"3","centeredSlides":"true"}}}\'>';
	                    echo '<div class="swiper-wrapper">';

	                    	$mask = $settings['shape']['url'] ? $settings['shape']['url'] : '#';

	                        foreach( $settings['slides'] as $data ){
		                        echo '<div class="swiper-slide">';
		                            echo '<div class="testi-card style2">';
		                                echo '<div class="testi-card_wrapper">';
		                                    echo '<div class="testi-card_profile" data-mask-src="'.esc_url( $mask ).'">';
		                                    	if(!empty($data['client_image']['url'])){
			                                        echo '<div class="testi-card_avater">';
			                                            echo tourm_img_tag( array(
															'url'	=> esc_url( $data['client_image']['url'] ),
														) );
			                                        echo '</div>';
			                                    }
		                                        echo '<div class="media-body">';
		                                        	if(!empty($data['client_name'])){
														echo '<h3 class="box-title name">'.esc_html( $data['client_name'] ).'</h3>';
													}
													if(!empty($data['client_desig'])){
														echo '<span class="testi-card_desig desig">'.esc_html( $data['client_desig'] ).'</span>';
													}
		                                        echo '</div>';
		                                    echo '</div>';
		                                    echo '<div class="testi-card_review">';
		                                        if( $data['client_rating'] == '1' ){
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
												}elseif( $data['client_rating'] == '2' ){
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
												}elseif( $data['client_rating'] == '3' ){
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
												}elseif( $data['client_rating'] == '4' ){
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-regular fa-star"></i>';
												}else{
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
												}
		                                    echo '</div>';
		                                echo '</div>';
		                                if(!empty($data['client_feedback'])){
			                                echo '<p class="testi-card_text text">'.esc_html( $data['client_feedback'] ).'</p>';
			                            }
			                            if(!empty( $settings['quote']['url'] )){
			                                echo '<div class="testi-card-quote">';
			                                    echo tourm_img_tag( array(
													'url'	=> esc_url( $settings['quote']['url'] ),
												) );
			                                echo '</div>';
			                            }
		                            echo '</div>';
		                        echo '</div>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '6' ){
			echo '<div class="swiper th-slider testiSlide5" id="testiSlide7" data-slider-options=\'{"effect":"slide","loop":false,"thumbs":{"swiper":".testi-grid2-thumb"}}\'>';
                echo '<div class="swiper-wrapper">';

                	foreach( $settings['slides'] as $data ){
	                    echo '<div class="swiper-slide">';
	                        echo '<div class="testi-grid2">';
	                            echo '<div class="box-content">';
	                            	if(!empty($data['client_feedback'])){
		                                echo '<p class="box-text text">'.esc_html( $data['client_feedback'] ).'</p>';
		                            }
	                                if(!empty($data['client_name'])){
										echo '<h6 class="box-title name">'.esc_html( $data['client_name'] ).'</h6>';
									}
									if(!empty($data['client_desig'])){
										echo '<span class="box-desig desig">'.esc_html( $data['client_desig'] ).'</span>';
									}
	                                echo '<div class="box-review">';
	                                	if( $data['client_rating'] == '1' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '2' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '3' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '4' ){
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-regular fa-star"></i>';
										}else{
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
											echo '<i class="fa-sharp fa-solid fa-star"></i>';
										}
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';
            echo '<div class="swiper th-slider testi-grid2-thumb style2" data-slider-options=\'{"effect":"slide","slidesPerView":"6","spaceBetween":7,"loop":false}\'>';
                echo '<div class="icon-box">';
                    echo '<button data-slider-prev="#testiSlide7" class="slider-arrow default"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/right-arrow2.svg" alt=""></button>';
                    echo '<button data-slider-next="#testiSlide7" class="slider-arrow default"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow2.svg" alt=""></button>';
                echo '</div>';
                echo '<div class="swiper-wrapper">';
                    foreach( $settings['slides'] as $data ){
	                    echo '<div class="swiper-slide">';
	                        echo '<div class="box-img">';
	                        	if(!empty($data['client_image']['url'])){
                                    echo tourm_img_tag( array(
										'url'	=> esc_url( $data['client_image']['url'] ),
									) );
                                }
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';
		}
	}
}