<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Megamenu Widget .
 *
 */
class Tourm_Megamenu extends Widget_Base {

	public function get_name() {
		return 'tourmcat';
	}
	public function get_title() {
		return __( 'Megamenu', 'tourm' );
	}
	public function get_icon() {
		return 'vt-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'		 	=> __( 'Megamenu', 'tourm' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One'] );


		$fields_to_include = [ 'image' => ['Image'], 'title' => ['Title','URL']  ];
		tourm_repeater_fields( $this, 'cat_list', 'Megamenu Lists', $fields_to_include, ['1'] );



        $this->end_controls_section();





	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<li>';
                echo '<div class="container">';
	                echo '<div class="row gy-4">';
	                    foreach( $settings['cat_list'] as $data ){
		                    echo '<div class="col-lg-3">';
		                        echo '<div class="mega-menu-box">';
		                            echo '<div class="mega-menu-img">';
		                                echo '<img src="'.esc_url( $data['image']['url'] ).'" alt="Home One">';
		                                echo '<div class="btn-wrap">';
		                                    echo '<a target="_blank" href="'.esc_url( $data['url'] ).'" class="th-btn ">View Demo</a>';
		                                echo '</div>';
		                            echo '</div>';
		                            if(!empty( $data['title'] )){
			                            echo '<h3 class="mega-menu-title"><a href="'.esc_url( $data['url'] ).'">'.wp_kses_post( $data['title'] ).'</a></h3>';
			                        }
		                        echo '</div>';
		                    echo '</div>';
		                }
	                echo '</div>';
                echo '</div>';
            echo '</li>';
		}
	}
}