<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Widget .
 *
 */
class tourm_Feature extends Widget_Base {

	public function get_name() {
		return 'tourmfeatures';
	}
	public function get_title() {
		return __( 'Tourm Features', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Features', 'tourm' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two', 'Style Three', 'Style Four'] );

		$fields_to_include = [ 'image' => ['Icon Image'], 'title' => ['Title','Description'] ];
		tourm_repeater_fields( $this, 'service_list', 'Feature Lists', $fields_to_include, ['1','2','3','4'] );


        $this->end_controls_section();

		tourm_common2_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .box-title', ['1','2','3','4'] );
		tourm_common2_style_fields( $this, 'title3', 'Description', '{{WRAPPER}} .desc', ['1','2','3','4'] );


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="about-item-wrap">';
                foreach( $settings['service_list'] as $data ){            
	                echo '<div class="about-item">';
	                	if(!empty($data['icon_image']['url'])){
		                    echo '<div class="about-item_img"><img src="'.esc_url( $data['icon_image']['url'] ).'" alt=""></div>';
		                }
	                    echo '<div class="about-item_centent">';
	                    	if(!empty($data['title'])){
		                        echo '<h5 class="box-title title">'.esc_html($data['title']).'</h5>';
		                    }
		                    if(!empty($data['description'])){
		                        echo '<p class="about-item_text desc">'.esc_html($data['description']).'</p>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="about-item-wrap">';
                foreach( $settings['service_list'] as $data ){            
	                echo '<div class="about-item style2">';
	                	if(!empty($data['icon_image']['url'])){
		                    echo '<div class="about-item_img"><img src="'.esc_url( $data['icon_image']['url'] ).'" alt=""></div>';
		                }
	                    echo '<div class="about-item_centent">';
	                    	if(!empty($data['title'])){
		                        echo '<h5 class="box-title title">'.esc_html($data['title']).'</h5>';
		                    }
		                    if(!empty($data['description'])){
		                        echo '<p class="about-item_text desc">'.esc_html($data['description']).'</p>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="row gy-4 justify-content-center">';
                foreach( $settings['service_list'] as $data ){    
	                echo '<div class="col-md-6 col-xl-3">';
	                    echo '<div class="feature-item th-ani">';
	                    	if(!empty($data['icon_image']['url'])){
		                        echo '<div class="feature-item_icon">';
		                            echo '<img src="'.esc_url( $data['icon_image']['url'] ).'" alt="icon">';
		                        echo '</div>';
		                    }
	                        echo '<div class="media-body">';
	                        	if(!empty($data['title'])){
			                        echo '<h3 class="box-title title">'.esc_html($data['title']).'</h3>';
			                    }
			                    if(!empty($data['description'])){
		                            echo '<p class="feature-item_text desc">'.esc_html($data['description']).'</p>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}else{
			foreach( $settings['service_list'] as $data ){ 
				echo '<div class="choose-about wow fadeInUp">';
					if(!empty($data['icon_image']['url'])){
		                echo '<div class="choose-about_icon">';
		                    echo '<img src="'.esc_url( $data['icon_image']['url'] ).'" alt="icon">';
		                echo '</div>';
		            }
	                echo '<div class="media-body">';
	                    if(!empty($data['title'])){
	                        echo '<h3 class="box-title ">'.esc_html($data['title']).'</h3>';
	                    }
	                    if(!empty($data['description'])){
		                    echo '<p class="choose-about_text desc">'.esc_html($data['description']).'</p>';
		                }
	                echo '</div>';
	            echo '</div>';
	        }
		}
	}
}