<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Offer Widget .
 *
 */
class tourm_Offer extends Widget_Base {

	public function get_name() {
		return 'tourmoffer';
	}
	public function get_title() {
		return __( 'Offer', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'faq_section',
			[
				'label'		 	=> __( 'Offer', 'tourm' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One'] );


        $fields_to_include = [ 'image' => ['Image'], 'title' => ['Title','Price'] ];
		tourm_repeater_fields( $this, 'offer_list', 'Offer Lists', $fields_to_include, ['1'] );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//--------------------------------------- 

		tourm_common2_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .title_t');
		tourm_common2_style_fields( $this, 'title3', 'Price', '{{WRAPPER}} .price_t');

	}

	protected function render() {

	$settings = $this->get_settings_for_display();


		if($settings['layout_style'] == '1'){
			
			echo '<div class="offer-deals-wrapp">';
                echo '<div class="accordion-item-wrapp" id="offerDeals">';

                	$x = 0;
					foreach( $settings['offer_list'] as $key => $single_data ){
						$x++;



						if( $x == 1 ){
							$ariaexpanded 	= 'true';
							$class 			= 'show';
							$collesed 		= '';
							$is_active 		= 'active';
						}else{
							$ariaexpanded 	= 'false';
							$class 			= '';
							$collesed 		= 'collapsed';
							$is_active 		= '';
						}
	                    echo '<div class="accordion-item-content">';
	                        echo '<div class="accordion-tab-item" data-bs-toggle="tab" data-bs-target="#tab'.esc_attr( $x ).'">';
	                            echo '<div class="accordion-item">';
	                                echo '<div class="accordion-header" id="collapse-item-'.esc_attr( $x ).'">';
	                                    echo '<div class="accordion-button '.esc_attr( $collesed ).'" role="button" data-bs-toggle="collapse" data-bs-target="#collapse-'.esc_attr( $x ).'" aria-expanded="'.esc_attr( $ariaexpanded ).'" aria-controls="collapse-'.esc_attr( $x ).'">';
	                                        echo '<span class="accordion-item_info"><span class="box-title title_t">'.esc_html( $single_data['title'] ).'</span><i class="fa-thin fa-angle-down"></i></span>';
	                                    echo '</div>';
	                                echo '</div>';
	                                echo '<div id="collapse-'.esc_attr( $x ).'" class="accordion-collapse collapse '.esc_attr( $class ).'" aria-labelledby="collapse-item-'.esc_attr( $x ).'" data-bs-parent="#offerDeals">';
	                                    echo '<div class="accordion-body">';
	                                        echo '<span class="faq-price price_t">'.esc_html( $single_data['price'] ).'</span>';
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                    


                    echo '<div id="tabs-content">';

                        $x = 0;
						foreach( $settings['offer_list'] as $key => $single_data ){
							$x++;
	                        echo '<div id="tab'.esc_attr( $x ).'" class="according-img-tab">';
	                        	if(!empty( $single_data['image']['url'] )){
		                            echo '<img src="'.esc_url( $single_data['image']['url'] ).'" alt="">';
		                        }
	                        echo '</div>';
	                    }
                        

                    echo '</div>';
                echo '</div>';

            echo '</div>';
		}
	
	}
}