<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Tour Trip Widget .
 *
 */
class tourm_Tour_Trip extends Widget_Base {

	public function get_name() {
		return 'tourmtrips';
	}
	public function get_title() {
		return __( 'Tour Trip', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Tour Trip', 'tourm' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two', 'Style Three', 'Style Four'] );


		$fields_to_include = [ 'image' => ['Thumb Image'], 'title' => ['Title', 'Price', 'Duration', 'Loactions'],'btn' => ['Button Text'], 'url' => ['URL'] ];
		tourm_repeater_fields( $this, 'trip_list', 'Tour Trip Lists', $fields_to_include, ['1','2','4'] );


		tourm_general_fields( $this, 'length_t', 'Length Label', 'TEXTAREA2', 'Length', [ '3' ] );
		tourm_general_fields( $this, 'capacity_t', 'Capacity Label', 'TEXTAREA2', 'Capacity', [ '3' ] );
		tourm_general_fields( $this, 'type_t', 'Type Label', 'TEXTAREA2', 'Type', [ '3' ] );

		$fields_to_include2 = [ 'image' => ['Thumb Image'], 'title' => ['Title', 'Price', 'Length', 'Type', 'Capacity'],'btn' => ['Button Text'], 'url' => ['URL'] ];
		tourm_repeater_fields( $this, 'trip_list2', 'Tour Trip Lists', $fields_to_include2, ['3'] );


        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start

		tourm_common2_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .title a', ['1','2','3','4'] );
		tourm_common2_style_fields( $this, 'title3', 'Price', '{{WRAPPER}} .price', ['1','2','3','4'] );
		tourm_common2_style_fields( $this, 'title4', 'Duration', '{{WRAPPER}} .duration', ['1','2','3','4'] );
		

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="slider-area tour-slider">';
                echo '<div class="swiper th-slider tourSlider2 has-shadow slider-drag-wrap" id="tourSlider2" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"480":{"slidesPerView":2},"576":{"slidesPerView":"2"},"1199":{"slidesPerView":"3"},"1400":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';

                    	foreach( $settings['trip_list'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="tour-card th-ani  gsap-cursor">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="tour-card_img global-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="tour-content">';
	                                	if(!empty($data['title'])){
		                                    echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                                }
		                                if(!empty($data['loactions'])){
		                                    echo '<div class="tour-location">';
		                                        echo '<span><i class="fa-light fa-location"></i>'.esc_html($data['loactions']).'</span>  ';
		                                    echo '</div>';
		                                }
	                                    if(!empty($data['price'])){
		                                    echo '<h4 class="tour-card_price price">'.wp_kses_post($data['price']).'</h4>';
		                                }
	                                    echo '<div class="tour-action">';
	                                    	if(!empty($data['duration'])){
		                                        echo '<span class="durations"><i class="fa-light fa-clock"></i>'.esc_html($data['duration']).'</span>';
		                                    }
		                                    if(!empty($data['button_text'])){
		                                        echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style4">'.esc_html($data['button_text']).'</a>';
		                                    }
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="slider-area tour-slider ">';
                echo '<div class="swiper th-slider has-shadow slider-drag-wrap" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"},"1400":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';

                        foreach( $settings['trip_list'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="tour-box th-ani gsap-cursor">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="tour-box_img global-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="tour-content">';
	                                    if(!empty($data['title'])){
		                                    echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                                }
	                                    if(!empty($data['loactions'])){
		                                    echo '<div class="tour-location">';
		                                        echo '<span><i class="fa-light fa-location"></i>'.esc_html($data['loactions']).'</span>  ';
		                                    echo '</div>';
		                                }
	                                    if(!empty($data['price'])){
		                                    echo '<h4 class="tour-box_price price">'.wp_kses_post($data['price']).'</h4>';
		                                }
	                                    echo '<div class="tour-action">';
	                                        if(!empty($data['duration'])){
		                                        echo '<span class="durations"><i class="fa-light fa-clock"></i>'.esc_html($data['duration']).'</span>';
		                                    }
		                                    if(!empty($data['button_text'])){
		                                        echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style4 th-icon">'.esc_html($data['button_text']).'</a>';
		                                    }
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';

                    echo '<div class="slider-pagination"></div>';
                echo '</div>';

            echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="slider-area tour-slider ">';
                echo '<div class="swiper th-slider has-shadow slider-drag-wrap" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3","spaceBetween":"24"}}}\'>';
                    echo '<div class="swiper-wrapper">';


                    $length 	= $settings['length_t'] ? $settings['length_t'] : 'Length';
                    $capacity 	= $settings['capacity_t'] ? $settings['capacity_t'] : 'Capacity';
                    $type 		= $settings['type_t'] ? $settings['type_t'] : 'Capacity';

                        foreach( $settings['trip_list2'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="tour-box style2 th-ani gsap-cursor">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="tour-box_img global-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="tour-content">';
	                                    if(!empty($data['title'])){
		                                    echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                                }
	                                    echo '<div class="tour-list">';
	                                        echo '<ul>';
	                                        	if(!empty( $data['length'] )){
		                                            echo '<li>'.esc_html( $length ).'<span>'.esc_html( $data['length'] ).'</span></li>';
		                                        }
		                                        if(!empty( $data['length'] )){
		                                            echo '<li>'.esc_html( $capacity ).'<span>'.esc_html( $data['capacity'] ).'</span></li>';
		                                        }
		                                        if(!empty( $data['length'] )){
		                                            echo '<li>'.esc_html( $type ).'<span>'.esc_html( $data['type'] ).'</span></li>';
		                                        }

	                                        echo '</ul>';
	                                    echo '</div>';
	                                    echo '<div class="tour-action">';
	                                    	if(!empty($data['price'])){
			                                    echo '<h4 class="tour-box_price price">'.wp_kses_post($data['price']).'</h4>';
			                                }
			                                if(!empty($data['button_text'])){
		                                        echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style4 th-icon">'.esc_html($data['button_text']).'</a>';
		                                    }
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}else{
			echo '<div class="slider-area tour-slider ">';
                echo '<div class="swiper th-slider has-shadow slider-drag-wrap" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';

                        foreach( $settings['trip_list'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="tour-box style4 th-ani gsap-cursor">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="tour-box_img global-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="tour-content">';
	                                    if(!empty($data['title'])){
		                                    echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                                }
	                                    if(!empty($data['loactions'])){
		                                    echo '<div class="tour-location">';
		                                        echo '<span><i class="fa-light fa-location"></i>'.esc_html($data['loactions']).'</span>  ';
		                                    echo '</div>';
		                                }
	                                    if(!empty($data['price'])){
		                                    echo '<h4 class="tour-box_price price">'.wp_kses_post($data['price']).'</h4>';
		                                }
	                                    echo '<div class="tour-action">';
	                                        if(!empty($data['duration'])){
		                                        echo '<span class="durations"><i class="fa-light fa-clock"></i>'.esc_html($data['duration']).'</span>';
		                                    }
		                                    if(!empty($data['button_text'])){
		                                        echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style4 th-icon">'.esc_html($data['button_text']).'</a>';
		                                    }
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';

            echo '</div>';
		}
	}
}