<?php
/**
 * Contains the query functions for WP Travel Engine which alter the front-end post queries and loops
 *
 * @version 3.1.9
 * @package WP Travel_Engine\includes\dashboard
 * @author  WP Travel Engine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WP_Travel_Engine_Query Class.
 */
class WP_Travel_Engine_Query {

	/**
	 * Query vars to add to wp.
	 *
	 * @var array
	 */
	public $query_vars = array();

	/**
	 * Stores chosen attributes.
	 *
	 * @var array
	 */
	private static $_chosen_attributes;

	/**
	 * Constructor for the query class. Hooks in methods.
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'add_endpoints' ) );
		if ( ! is_admin() ) {
			add_filter( 'query_vars', array( $this, 'add_query_vars' ), 0 );
		}
		$this->init_query_vars();
	}

	/**
	 * Init query vars by loading options.
	 */
	public function init_query_vars() {
		// Query vars to add to WP.
		$this->query_vars = array(
			'wp-travel-engine-lost-pass'       => 'wp-travel-engine-lost-pass',
			'wp-travel-engine-customer-logout' => 'wp-travel-engine-customer-logout',
		);
	}


	/**
	 * Add query vars.
	 *
	 * @access public
	 *
	 * @param array $vars Query vars.
	 *
	 * @return array
	 */
	public function add_query_vars( $vars ) {
		foreach ( $this->get_query_vars() as $key => $var ) {
			$vars[] = $key;
		}

		return $vars;
	}

	/**
	 * Get query vars.
	 *
	 * @return array
	 */
	public function get_query_vars() {
		return apply_filters( 'wp_travel_engine_get_query_vars', $this->query_vars );
	}

	/**
	 * Endpoint mask describing the places the endpoint should be added.
	 *
	 * @return int
	 * @since 2.6.2
	 */
	public function get_endpoints_mask() {
		if ( 'page' === get_option( 'show_on_front' ) ) {
			$page_on_front   = get_option( 'page_on_front', array() );
			$settings        = get_option( 'wp_travel_engine_settings', array() );
			$account_page_id = $settings[ 'pages' ][ 'wp_travel_engine_dashboard_page' ] ?? wp_travel_engine_get_page_id( 'my-account' );


			if ( in_array( $page_on_front, array( $account_page_id ), true ) ) {
				return EP_ROOT | EP_PAGES;
			}
		}

		return EP_PAGES;
	}

	/**
	 * Add endpoints for query vars.
	 */
	public function add_endpoints() {
		$mask = $this->get_endpoints_mask();

		foreach ( $this->get_query_vars() as $key => $var ) {
			if ( ! empty( $var ) ) {
				add_rewrite_endpoint( $var, $mask );
			}
		}
	}

}

new WP_Travel_Engine_Query();
